#/** @file
# Build discription file to generate Shell DP application.
# 
# Copyright (c) 2009 Intel Corporation. All rights reserved
# This software and associated documentation (if any) is furnished
# under a license and may only be used or copied in accordance
# with the terms of the license. Except as permitted by such
# license, no part of this software or documentation may be
# reproduced, stored in a retrieval system, or transmitted in any
# form or by any means without the express written consent of
# Intel Corporation.
#
# **/

[Defines]
  PLATFORM_NAME                  = TPM2ProvTool
  PLATFORM_GUID                  = ba03c60e-e9c1-4b98-8c92-95254fd33844
  PLATFORM_VERSION               = 0.1
  DSC_SPECIFICATION              = 0x00010005
  OUTPUT_DIRECTORY               = Build/TPM2ProvTool
  SUPPORTED_ARCHITECTURES        = IA32|X64
  BUILD_TARGETS                  = DEBUG|RELEASE
  SKUID_IDENTIFIER               = DEFAULT

[LibraryClasses]
#EntryPoint#
 UefiApplicationEntryPoint|MdePkg/Library/UefiApplicationEntryPoint/UefiApplicationEntryPoint.inf 

 UefiBootServicesTableLib|MdePkg/Library/UefiBootServicesTableLib/UefiBootServicesTableLib.inf
 DebugLib|MdePkg/Library/UefiDebugLibConOut/UefiDebugLibConOut.inf
 BaseMemoryLib|MdePkg/Library/BaseMemoryLib/BaseMemoryLib.inf
 BaseLib|MdePkg/Library/BaseLib/BaseLib.inf
 PcdLib|MdePkg/Library/BasePcdLibNull/BasePcdLibNull.inf
 PrintLib|MdePkg/Library/BasePrintLib/BasePrintLib.inf
 DebugPrintErrorLevelLib|MdePkg/Library/BaseDebugPrintErrorLevelLib/BaseDebugPrintErrorLevelLib.inf

 UefiLib|MdePkg/Library/UefiLib/UefiLib.inf
 MemoryAllocationLib|MdePkg/Library/UefiMemoryAllocationLib/UefiMemoryAllocationLib.inf
 DevicePathLib|MdePkg/Library/UefiDevicePathLib/UefiDevicePathLib.inf
 UefiRuntimeServicesTableLib|MdePkg/Library/UefiRuntimeServicesTableLib/UefiRuntimeServicesTableLib.inf

 UefiShellLib|ShellPkg/Library/UefiShellLib/UefiShellLib.inf
 #FileHandleLib|ShellPkg/Library/UefiFileHandleLib/UefiFileHandleLib.inf
 HiiLib|MdeModulePkg/Library/UefiHiiLib/UefiHiiLib.inf
 UefiHiiServicesLib|MdeModulePkg/Library/UefiHiiServicesLib/UefiHiiServicesLib.inf

 IoLib|MdePkg/Library/BaseIoLibIntrinsic/BaseIoLibIntrinsic.inf
 #SortLib|ShellPkg/Library/UefiSortLib/UefiSortLib.inf
 
 IntrinsicLib|CryptoPkg/Library/IntrinsicLib/IntrinsicLib.inf
 OpensslLib|CryptoPkg/Library/OpensslLib/OpensslLib.inf
 #BaseCryptLib|CryptoPkg/Library/BaseCryptLib/BaseCryptLib.inf

 ShellCEntryLib|ShellPkg/Library/UefiShellCEntryLib/UefiShellCEntryLib.inf
 UefiRuntimeLib|MdePkg/Library/UefiRuntimeLib/UefiRuntimeLib.inf  
 UefiDriverEntryPoint|MdePkg/Library/UefiDriverEntryPoint/UefiDriverEntryPoint.inf
 
[Components.common]
 TPM2ProvTool/TPM2ProvTool.inf {
    <LibraryClasses>
      NULL|MdeModulePkg/Universal/Disk/UnicodeCollation/EnglishDxe/EnglishLib.inf
  }

 !include StdLib/StdLib.inc
  
  
[BuildOptions]
  DEBUG_*_IA32_DLINK_FLAGS = /EXPORT:InitializeDriver=$(IMAGE_ENTRY_POINT) /ALIGN:4096 /SUBSYSTEM:CONSOLE
  RELEASE_*_IA32_DLINK_FLAGS = /ALIGN:4096
  *_*_IA32_CC_FLAGS = /D EFI_SPECIFICATION_VERSION=0x0002000A /D TIANO_RELEASE_VERSION=0x00080006 /D CL_EFI_32 /I"C:\Program Files\Microsoft Visual Studio 9.0\VC\include"

DEBUG_VS2008_X64_CC_FLAGS = /D XML_STATIC /D HAVE_MEMMOVE=1 /D X86_64 /D DEBUG_BUILD /FAcs /W0 /Oi- /wd4018 /wd4131

RELEASE_VS2008_X64_CC_FLAGS = /D XML_STATIC /D HAVE_MEMMOVE=1 /D X86_64


